/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.market.integration;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.market.dto.GoodsCommissionDTO;
import com.bxm.localnews.market.dto.MerchantRateDTO;
import com.bxm.localnews.market.facade.MerchantGoodsFeignService;
import com.bxm.localnews.market.model.dto.MerchantGoodsInfoDTO;
import com.bxm.localnews.market.model.vo.MerchantInfoSimpleVO;
import com.bxm.localnews.market.param.AfterOrderPaySuccessParam;
import com.bxm.localnews.market.param.OperatorMerchantAccountParam;
import com.bxm.newidea.component.vo.Message;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import java.util.Objects;

import static com.alibaba.fastjson.JSON.toJSONString;

/**
 * @author jieliGG
 * @date 2020/8/25 20:04
 **/
@Slf4j
@Component
public class MerchantGoodsIntegrationService {

    @Autowired
    private MerchantGoodsFeignService merchantGoodsFeignService;

    /**
     * 获取商家的商品配置信息
     *
     * @return 商家的商品配置信息
     */
    public MerchantRateDTO getMerchantGoodsRate() {
        try {
            ResponseEntity<MerchantRateDTO> responseEntity = merchantGoodsFeignService.getMerchantGoodsRate();

            if (Objects.nonNull(responseEntity)) {
                return responseEntity.getBody();
            }
        } catch (Exception e) {
            log.error("获取商家的商品配置信息失败", e);
        }
        return null;
    }

    /**
     * 退还商品的库存
     *
     * @param goodsId ： 商品id
     * @param num     : 退还数量
     * @return
     */
    public Boolean returnGoodsNum(Long goodsId, Long num) {
        if (num > 0) {
            num = num * -1;
        }

        try {
            ResponseEntity<Boolean> responseEntity = merchantGoodsFeignService.returnGoodsNum(goodsId, num);

            if (Objects.nonNull(responseEntity)) {
                return responseEntity.getBody();
            }
        } catch (Exception e) {
            log.error("调用商家服务失败, goodsId: {}, num: {} ", goodsId, num, e);
        }
        return Boolean.FALSE;
    }

    /**
     * 操作商家账户
     *
     * @return
     */
    public Boolean operatorMerchantAccount(OperatorMerchantAccountParam merchantAccountParam) {
        try {
            ResponseEntity<Boolean> responseEntity = merchantGoodsFeignService.operatorMerchantAccount(merchantAccountParam);

            if (Objects.nonNull(responseEntity)) {
                return responseEntity.getBody();
            }
        } catch (Exception e) {
            log.error("调用商家服务失败 merchantAccountParam: {}", toJSONString(merchantAccountParam), e);
        }

        return Boolean.FALSE;
    }


    /**
     * 获取商家商品信息
     *
     * @param goodsId ： 商品id
     * @return : 商家商品信息
     */
    public MerchantGoodsInfoDTO getMerchantGoodsById(Long goodsId) {
        try {
            ResponseEntity<MerchantGoodsInfoDTO> responseEntity = merchantGoodsFeignService.getMerchantGoodsById(goodsId);

            if (Objects.nonNull(responseEntity)) {
                return responseEntity.getBody();
            }
        } catch (Exception e) {
            log.error("获取商家商品信息失败 goodsId: {}", goodsId, e);
        }
        return null;
    }

    /**
     * 获取商品id获取商户信息
     *
     * @param goodsId 商品id
     * @return 商户信息
     */
    public MerchantInfoSimpleVO getMerchantInfoSimpleInfo(Long goodsId) {

        try {
            ResponseEntity<MerchantInfoSimpleVO> responseEntity = merchantGoodsFeignService.getMerchantInfoSimpleInfo(goodsId);

            if (Objects.nonNull(responseEntity)) {
                return responseEntity.getBody();
            }
        } catch (Exception e) {
            log.error("获取商品id获取商户信息失败, goodsId: {}", goodsId, e);
        }
        return null;
    }

    /**
     * 扣除商品数量
     *
     * @param goodsId ： 商品id
     * @param num     : 扣除数量
     * @return
     */
    public Boolean subOrderNum(Long goodsId, Integer num) {
        if (num < 0) {
            num = num * -1;
        }

        try {
            ResponseEntity<Boolean> responseEntity = merchantGoodsFeignService.subOrderNum(goodsId, num);
            return Objects.nonNull(responseEntity) ? responseEntity.getBody() : false;
        } catch (Exception e) {
            log.error("请求商家模块出错, goodsId : {}, num: {}", goodsId, num, e);
        }
        return false;
    }

    /***
     * 获取邀请好友的信息
     * @param goodsId  : 商品id
     * @param num : 数量
     * @return ： 返回邀请记录
     */
    public Message checkGoodsStatus(Long goodsId, Integer num, Long useId) {
        try {
            ResponseEntity<Message> responseEntity = merchantGoodsFeignService.checkGoodsStatus(goodsId, num, useId);
            if (Objects.nonNull(responseEntity)) {
                return responseEntity.getBody();
            }
        } catch (Exception e) {
            log.error("调用商家服务失败, goodsId: {}, num: {}, userId: {}", goodsId, num, useId, e);
        }

        return Message.build(false);
    }

    /**
     * 根据商品id获取商品的佣金
     *
     * @param goodsId goodsId
     * @return 商品的佣金 可能为空
     */
    public GoodsCommissionDTO getCommission(Long goodsId, Boolean isVip) {
        try {
            ResponseEntity<GoodsCommissionDTO> commission = merchantGoodsFeignService.getCommission(goodsId, isVip);

            if (Objects.nonNull(commission) && commission.hasBody()) {
                return commission.getBody();
            }
        } catch (Exception e) {
            log.error("根据商品id获取商品的佣金失败, goodsId: {}", goodsId, e);
        }

        return null;
    }

    /**
     * 商家商品下单支付成功之后的处理
     *
     * @param param param
     */
    public void afterOrderPaySuccess(AfterOrderPaySuccessParam param) {
        try {
            merchantGoodsFeignService.afterOrderPaySuccess(param);

        } catch (Exception e) {
            log.error("商家商品下单支付成功之后的处理 调用商户服务失败 param: {}", JSON.toJSONString(param), e);
        }
    }

}
