package com.bxm.localnews.market.integration;

import com.bxm.localnews.market.dto.MerchantInfo;
import com.bxm.localnews.market.facade.MerchantInfoFeignService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * @author gonzo
 * @date 2020-12-21 18:29
 **/
@Slf4j
@Component
@AllArgsConstructor
public class MerchantInfoIntegrationService {

    private final MerchantInfoFeignService merchantInfoFeignService;


    /**
     * 根据商家id获取商家信息
     *
     * @param merchantId 商家id
     * @return 商家信息
     */
    public MerchantInfo getMerchantInfo(Long merchantId) {
        try {
            ResponseEntity<MerchantInfo> merchantInfo = merchantInfoFeignService.getMerchantInfo(merchantId);

            if (Objects.nonNull(merchantInfo) && merchantInfo.hasBody()) {
                return merchantInfo.getBody();
            }

        } catch(Exception e) {
            log.error("获取商家信息失败, merchantId: {}", merchantId, e);
        }

        return null;
    }
}
