package com.bxm.localnews.market.integration;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.base.integration.DomainIntegrationService;
import com.bxm.localnews.base.model.dto.ViewSceneDomain;
import com.bxm.localnews.common.constant.DomainScene;
import com.bxm.localnews.market.facade.MsgPushFeignService;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.enums.NotifyParamEnum;
import com.bxm.localnews.mq.common.enums.WxMpTemplateEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.mq.common.param.WechatMpPushMessage;
import com.bxm.localnews.msg.sender.MessageSender;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Optional;

/**
 * @author zhaoyadong 2019/3/1 10:11
 * @desc
 */
@Slf4j
@Service
@AllArgsConstructor
public class MessageUserIntegrationService extends BaseService {

    private final MessageSender messageSender;

    private final SequenceCreater sequenceCreater;

    private final MsgPushFeignService msgPushFeignService;

    private final DomainIntegrationService domainIntegrationService;

    /**
     * 推送消息
     *
     * @param message message
     */
    public void pushMsg(PushMessage message) {
        if (log.isDebugEnabled()) {
            log.debug("推送消息: {}", JSON.toJSONString(message));
        }
        try {
            messageSender.sendPushMessage(message);
        } catch (Exception e) {
            log.error("推送消息: {}失败", JSON.toJSONString(message), e);
        }

    }

    /**
     * 发送跟单成功推送
     *
     * @param content 推送内容
     * @param userId  用户id
     */
    public void pushOrderCommissionCheckMsg(String content, Long userId) {
        PushPayloadInfo info = PushPayloadInfo.build(PushMessageEnum.JUMP_TYPE);
        info.setMsgId(sequenceCreater.nextLongId());
        // 跳转我的订单
        info.setProtocol("wst://mine/billingDetail");

        PushMessage message = PushMessage.build();
        message.setTitle("佣金入账通知");
        message.setContent(content);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPushReceiveScope(PushReceiveScope.pushSignle(userId));
        message.setPayloadInfo(info);

        if (log.isDebugEnabled()) {
            log.debug("发送跟单成功推送: {}", JSON.toJSONString(message));
        }

        pushMsg(message);
    }


    public void doOfficialAccountPush(String nickname, BigDecimal commission, Long userId, Boolean isTeam, String url) {
        String price = commission.stripTrailingZeros().toPlainString();
        WechatMpPushMessage wechatMpPushMessage = WechatMpPushMessage.builder()
                .userId(userId)
                .wxMpTemplate(WxMpTemplateEnum.COMMISSION_GIVE_OUT)
                .url(StringUtils.join(getH5BaseUrl(), url))
                .build();
        String currDate = DateUtils.formatDateTime(new Date());
        wechatMpPushMessage
                .addValue(NotifyParamEnum.TITLE.getDesc(), String.format("%s收益到账通知", isTeam ? "团队" : "直卖"))
                .addVar(price + "元")
                .addVar(nickname)
                .addVar(currDate)
                .addValue(NotifyParamEnum.REMARK.getDesc(), "分享越多，收益更多哦~");

        if (log.isDebugEnabled()) {
            log.debug("推送公众号消息nickname：{},commission:{},userId:{},isTeam:{}  ", nickname, commission, userId, isTeam);
        }
        try {
            msgPushFeignService.officialAccountPush(wechatMpPushMessage);
        } catch (Exception e) {
            log.error("推送公众号消息出错nickname：{},commission:{},userId:{},isTeam:{}  ", nickname, commission, userId, isTeam, e);
        }
    }

    private String getH5BaseUrl() {
        Optional<ViewSceneDomain> viewSceneBaseUrl;
        try {
            viewSceneBaseUrl = domainIntegrationService.getViewSceneBaseUrl(DomainScene.DomainViewScene.WX_JS_VIEW);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return viewSceneBaseUrl.map(ViewSceneDomain::getBaseUrl).orElse(null);
    }

}
