package com.bxm.localnews.market.integration;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.market.dto.PaymentOrderInfoDTO;
import com.bxm.localnews.market.facade.PaymentInfoFeignService;
import com.bxm.localnews.market.model.dto.PaymentOrderDTO;
import com.bxm.localnews.market.model.param.order.UserOrderParam;
import com.bxm.localnews.market.param.RefundParam;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.ResponseJson;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * @author jieliGG
 * @date : 2020年9月3日 11:13:50
 */
@Slf4j
@Component
@AllArgsConstructor
public class PaymentInfoIntegrationService {

    private final PaymentInfoFeignService paymentInfoFeignService;

    /**
     * 创建支付订单
     *
     * @param param param
     * @return 支付订单信息
     */
    public PaymentOrderDTO orderCreate(UserOrderParam param) {
        try {
            ResponseJson<PaymentOrderDTO> paymentOrderDTOResponseJson = paymentInfoFeignService.orderCreate(param);
            if (Objects.nonNull(paymentOrderDTOResponseJson) && paymentOrderDTOResponseJson.success()
                    && Objects.nonNull(paymentOrderDTOResponseJson.getResult())) {
                return paymentOrderDTOResponseJson.getResult();
            }
        } catch (Exception e) {
            log.error("唤起支付订单失败, param: {}", JSON.toJSONString(param), e);
        }

        return null;
    }

    /**
     * 退单
     *
     * @param refundParam ： 退单参数
     * @return ： 退单结果
     */
    public Message refund(RefundParam refundParam) {
        try {
            ResponseJson<Message> refund = paymentInfoFeignService.refund(refundParam);

            if (Objects.nonNull(refund) && refund.success() && Objects.nonNull(refund.getResult())) {
                return refund.getResult();
            }

        } catch (Exception e) {
            log.error("处理退单失败, refundParam: {}", JSON.toJSONString(refundParam), e);
        }

        return Message.build(false);
    }

    /**
     * 根据订单号获取流水明细
     *
     * @param orderSn ： 订单号
     * @return 流水明细
     */
    public PaymentOrderInfoDTO getPaymentNumByOrderSn(String orderSn) {
        try {
            ResponseEntity<PaymentOrderInfoDTO> paymentNumByOrderSn = paymentInfoFeignService.getPaymentNumByOrderSn(orderSn);

            if (Objects.nonNull(paymentNumByOrderSn) && Objects.nonNull(paymentNumByOrderSn.getBody())) {
                return paymentNumByOrderSn.getBody();
            }

        } catch (Exception e) {
            log.error("请求支付服务获取流水明细失败, orderSn: {}", orderSn, e);
        }
        return null;
    }
}
