package com.bxm.localnews.market.integration;


import com.alibaba.fastjson.JSON;
import com.bxm.localnews.market.facade.UserAccountFeignService;
import com.bxm.localnews.market.param.AccountCashParam;
import com.bxm.localnews.market.param.AccountGoldParam;
import com.bxm.localnews.market.param.CashAccountParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * 用户账户服务integration服务
 */
@Slf4j
@Service
public class UserAccountIntegrationService {

    /**
     * 用户账户服务对外接收服务
     */
    @Resource
    private UserAccountFeignService userAccountFeignService;

    /**
     * 修改账户金币信息
     *
     * @param param
     * @return
     */
    public Boolean addGold(AccountGoldParam param) {
        return userAccountFeignService.addGold(param).getBody();
    }

    /**
     * 现金账户操作
     *
     * @param param 操作参数
     * @return 处理结果
     */
    public boolean cashAccountOperation(CashAccountParam param) {
        try {
            ResponseEntity responseEntity = userAccountFeignService.cashAccountOperation(param);
            return Objects.equals(responseEntity.getStatusCode(), HttpStatus.OK);
        } catch (Exception e) {
            log.error("现金账户操作失败: {}", JSON.toJSONString(param), e);
        }

        return false;
    }

    /**
     * 增加用户账户余额
     *
     * @param param 增加账户余额入参
     * @return 是否调用成功
     */
    public boolean cashAccount(AccountCashParam param) {
        try {
            ResponseEntity<Boolean> responseEntity = userAccountFeignService.cashAccount(param);
            return Objects.equals(responseEntity.getStatusCode(), HttpStatus.OK);
        } catch (Exception e) {
            log.error("添加用户账户省钱金额失败: {}", JSON.toJSONString(param), e);
        }

        return false;
    }

}
