package com.bxm.localnews.market.integration;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.market.dto.PayInfoDTO;
import com.bxm.localnews.market.facade.UserVipFeignService;
import com.bxm.localnews.market.facade.WithdrawFeignService;
import com.bxm.localnews.market.model.param.ActivationUserVipParam;
import com.bxm.localnews.market.param.VipQueryParam;
import com.bxm.localnews.user.model.VipInfoDetailDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * 用户vip服务integration服务
 *
 * @author wzy
 * @date 2020/8/11 0:36
 **/
@Slf4j
@Service
public class UserVipIntegrationService {

    private final UserVipFeignService userVipFeignService;

    private final WithdrawFeignService withdrawFeignService;
    @Autowired
    public UserVipIntegrationService(UserVipFeignService userVipFeignService, WithdrawFeignService withdrawFeignService) {
        this.userVipFeignService = userVipFeignService;
        this.withdrawFeignService = withdrawFeignService;
    }

    /**
     * 获取vip详细信息
     *
     * @param param 查询vip详细信息入参
     * @return vip详细信息对象
     */
    public VipInfoDetailDTO getVipDetail(VipQueryParam param) {
        try {
            ResponseEntity<VipInfoDetailDTO> responseEntity = userVipFeignService.getVipDetail(param);
            return responseEntity.getBody();
        } catch (Exception e) {
            log.error("获取vip详细信息失败: {}", JSON.toJSONString(param), e);
        }

        return new VipInfoDetailDTO();
    }

    /**
     * 获取vip相关支付信息
     * @return ： 支付信息
     */
    public PayInfoDTO getVipInfo(){
        return withdrawFeignService.getVipInfo().getBody();
    }

    /**
     * 获取vip详细信息
     * 和上面的不同是：实现里面的方法简单很多，只有一个status，其余没有
     *
     * @param userId 用户id
     * @return vip详细信息对象
     */
    public Boolean isVip(Long userId) {
        try {
            ResponseEntity<Boolean> responseEntity = userVipFeignService.isVip(userId);
            return responseEntity.getBody();
        } catch (Exception e) {
            log.error("获取vip信息失败");
        }
        return false;
    }

    /**
     * 用户付费购买VIP
     * @param param ： 入参
     * @return : VIP激活结果
     */
    public Boolean buyVip(ActivationUserVipParam param){
        try {
            ResponseEntity<Boolean> booleanResponseEntity = userVipFeignService.buyVip(param);
            if (Objects.nonNull(booleanResponseEntity) && booleanResponseEntity.hasBody()) {
                return booleanResponseEntity.getBody();
            }
        } catch(Exception e) {
            log.error("开通vip失败, param: {}", JSON.toJSONString(param), e);
        }
        return false;
    }
}
