package com.bxm.localnews.market.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author lowi
 * @date 2020/12/16 13:54
 */
@ApiModel("收益保存或更新类")
@Data
public class EarningsSaveOrUpdateParam {

    @ApiModelProperty("收益类型")
    private Integer earningsType;

    @ApiModelProperty("收益标题")
    private String earningsTitle;

    @ApiModelProperty("收益类型不同，代表不同类型的id")
    private Long relationId;

    @ApiModelProperty("收益的图片")
    private String img;

    @ApiModelProperty("订单号")
    private String orderNo;

    @ApiModelProperty("订单时间")
    private Date orderTime;

    @ApiModelProperty("（创造收益的用户id）购买的用户id")
    private Long createProfitUserId;

    @ApiModelProperty("购买用户的手机号")
    private String sellUserPhone;

    @ApiModelProperty("购买用户的姓名")
    private String sellUserName;

}
