package com.bxm.localnews.market.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 增加达人相关统计数据DTO(内部接口入参
 *
 * @author wzy
 * @version 1.0
 * @date 2020/12/17 1:50 下午
 */
@ApiModel("增加达人相关统计数据DTO(内部接口入参)")
@Data
public class IncreaseTalentDataParam {

    @ApiModelProperty("要增加达人数据的用户id")
    private Long userId;

    @ApiModelProperty("自购订单数量")
    private Integer purchaseOrderCount;

    @ApiModelProperty("分享订单数")
    private Integer shareOrderCount;

    @ApiModelProperty("自购收益")
    private BigDecimal purchaseProfile;

    @ApiModelProperty("分享收益")
    private BigDecimal shareProfile;

    @ApiModelProperty("向上级贡献金额")
    private BigDecimal superiorProfile;

    @ApiModelProperty("向上上级贡献金额")
    private BigDecimal onSuperiorProfile;

    @ApiModelProperty("贡献给上级订单数量")
    private Integer superiorOrderCount;

    @ApiModelProperty("贡献给上上级订单数量")
    private Integer onSuperiorOrderCount;
}