package com.bxm.localnews.market.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

@ApiModel(description = "下单时锁定用户优惠券")
@Data
@Builder
public class UserCouponOrderParam {

    @Tolerate
    public UserCouponOrderParam() {
    }

    @ApiModelProperty("用户优惠券ID")
    private Long userCouponId;

    @ApiModelProperty("对应下单的订单编号")
    private String orderNo;

    @ApiModelProperty("对应下单的订单标题")
    private String orderTitle;
}