package com.bxm.localnews.market.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel(description = "VIP信息查询")
public class VipQueryParam {
    @ApiModelProperty(value = "查询的目标用户ID", required = true)
    private Long userId;


    @ApiModelProperty(value = "用户所属地区", required = true)
    private String areaCode;

    @ApiModelProperty("请求场景，MAIN：VIP主页，OTHER：其他情况，不输入默认为其他。主页会返回额外的信息")
    private String scene;
}