package com.bxm.localnews.merchant.dto.activity;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.util.Date;

/**
 * @author liujia
 * @date 2020-10-23 10:11
 **/
@ApiModel(description = "活动奖品信息")
@Data
@Builder
public class ActivityPrizeInfoDTO {
    @Tolerate
    public ActivityPrizeInfoDTO() {
    }

    @ApiModelProperty("奖品头图")
    private String img;

    @ApiModelProperty("奖品标题")
    private String title;

    @ApiModelProperty("中奖时间（已格式化）")
    @JsonFormat(pattern = DateUtils.DATE_FORMAT_DAY_HOUR_MUNITE)
    private Date winnerTime;

    @ApiModelProperty("中奖人ID")
    private Long winnerUserId;

    @ApiModelProperty("中奖人昵称")
    private String winnerUserNickName;

    @ApiModelProperty("中奖人手机号码")
    private String winnerUserPhone;

    @ApiModelProperty("中奖人是否VIP")
    private Boolean winnerUserVipFlag;

    @ApiModelProperty("中奖纪录id")
    private Long winnerRecordId;

    @ApiModelProperty("核销奖品ID")
    private Long prizeId;

    @ApiModelProperty("奖品核销状态，0未发奖，1已发奖，2已核销, 3核销码错误")
    private Integer status;

    @ApiModelProperty(value = "核销奖品所属商家ID", hidden = true)
    @JsonIgnore
    private Long merchantId;
}
