package com.bxm.localnews.merchant.dto.activity;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author liujia
 * @date 2020-10-22 23:45
 **/
@Data
@ApiModel(description = "线索信息列表线索")
public class ActivityTrackOverviewDTO {

    @ApiModelProperty("提交时间（已格式化）")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date createTime;

    @ApiModelProperty("线索ID")
    private Long trackId;

    @ApiModelProperty("线索人名称")
    private String name;

    @ApiModelProperty("联系电话")
    private String phone;

    @ApiModelProperty("赞助内容")
    private String content;

    @ApiModelProperty("来源，1：站内，2：站外")
    private Byte source;

    @ApiModelProperty("提交信息的用户ID")
    private Long userId;

    @ApiModelProperty("运营备注信息")
    private String remark;
}


