package com.bxm.localnews.merchant.dto.activity;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author liujia
 * @date 2020-10-23 12:00
 **/
@ApiModel(description = "夺宝活动奖品详情")
@Data
public class LotteryAwardDetailDTO {

    @ApiModelProperty("奖品ID")
    private Long awardId;

    @ApiModelProperty("奖品类型，1：商品，2：其他")
    private Integer awardType;

    @ApiModelProperty("赞助商品ID，如果类型为商品时存在")
    private Long goodsId;

    @ApiModelProperty("商品名称【管理后台用用于修改时回显】")
    private String goodsName;

    @ApiModelProperty("奖品标题")
    private String awardTitle;

    @ApiModelProperty("赞助商家ID")
    private Long merchantId;

    @ApiModelProperty("奖品价值")
    private BigDecimal price;

    @ApiModelProperty("库存数量")
    private Integer stock;

    @ApiModelProperty("已发数量")
    private Integer useStock;

    @ApiModelProperty("奖品有效期开始时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date startTime;

    @ApiModelProperty("奖品过期时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date expiredTime;

    @ApiModelProperty("商品轮播图")
    private List<String> carouselList;

    @ApiModelProperty("商品轮播图地址字符串形式，按照,分割【仅管理后台用，其他接口不用管】")
    private String carouseStr;

    @ApiModelProperty("商家简介")
    private String intro;

    @ApiModelProperty("关注后的回复内容")
    private String replay;

    @ApiModelProperty("关注福利，不为空表示有福利")
    private Long couponId;

    @ApiModelProperty("奖品详情，富文本")
    private String detail;

    @ApiModelProperty("是否有福利【管理后台用】")
    private Integer welfare;

    @ApiModelProperty(hidden = true, value = "当前操作的运营ID")
    @JsonIgnore
    private Long currentUserId;
}
