package com.bxm.localnews.merchant.dto.activity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author liujia
 * @date 2020-10-23 11:55
 **/
@ApiModel(description = "活动奖品信息视图")
@Data
public class LotteryAwardOverviewDTO {

    @ApiModelProperty("奖品ID")
    private Long awardId;

    @ApiModelProperty("奖品标题")
    private String awardTitle;

    @ApiModelProperty("商家ID，可能为空说明没有商家赞助")
    private Long merchantId;

    @ApiModelProperty("商家名称，可能为空说明没有商家赞助")
    private String merchantName;

    @ApiModelProperty("奖品类型，1：商品，2：其他（待定）")
    private Integer awardType;

    @ApiModelProperty("奖品价值")
    private BigDecimal price;

    @ApiModelProperty("库存数量")
    private Integer stock;

    @ApiModelProperty("使用数量（已发放数量）")
    private Integer useStock;
}
