package com.bxm.localnews.merchant.dto.activity;

import com.bxm.localnews.merchant.dto.AreaInfoDTO;
import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @author liujia
 * @date 2020-10-23 09:00
 **/
@Data
@ApiModel(description = "活动详情实体")
public class LotteryDetailDTO {

    @ApiModelProperty("活动ID")
    private Long lotteryId;

    @ApiModelProperty("活动标题")
    private String title;

    @ApiModelProperty("奖品ID")
    private Long awardId;

    @ApiModelProperty("奖品标题")
    private String awardTitle;

    @ApiModelProperty("开奖需要的目标人数，最少50")
    private Integer targetNum;

    @ApiModelProperty("每日参与次数上限")
    private Integer maxTimes;

    @ApiModelProperty("单次参与消耗的小红花")
    private Integer expendGold;

    @ApiModelProperty("是否全国投放，1：全国，0：地区")
    private Integer globalFlag;

    @ApiModelProperty("投放的部分区域")
    private List<AreaInfoDTO> areaInfos;

    @ApiModelProperty("areaCode字符串【管理后台用】")
    private String areaCodeStr;

    @ApiModelProperty("活动投放时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date startTime;

    @ApiModelProperty("分享海报图片")
    private String sharePoster;

    @ApiModelProperty("当前活动的排序")
    private Integer order;

    @ApiModelProperty("是否真实用户中奖，1：真实用户中奖，0：马甲号中奖")
    private Integer actualFlag;

    @ApiModelProperty("马甲号是否参加，1：参加，0：不参加")
    private Integer virtualFlag;

    @ApiModelProperty("奖品库存数量")
    private Integer stock;

    @ApiModelProperty(value = "当前操作的运营用户ID,网关层附加", hidden = true)
    private Long currentUserId;

    @ApiModelProperty(value = "当前最新一期的ID", hidden = true)
    private Long currentPhaseId;

    @ApiModelProperty(value = "当前期数", hidden = true)
    private Integer currentPhaseNum;

    @ApiModelProperty(value = "活动状态", hidden = true)
    private Integer status;
}
