package com.bxm.localnews.merchant.dto.activity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

/**
 * @author liujia
 * @date 2020-10-22 18:57
 **/
@ApiModel(description = "参与夺宝活动的结果")
@Data
@Builder
public class LotteryJoinResultDTO {

    @Tolerate
    public LotteryJoinResultDTO() {
    }

    @ApiModelProperty("参与夺宝活动的结果，1：参与成功、2：参与次数已达上限，3:小红花不足活动，4:活动已结束，5：用户参与成功且未关注商家 " +
            "说明：如果状态是1参与成功，则直接展示夺宝码等信息，如果状态为2或3则进行相应的弹窗提示，如果状态是4活动已结束，则判断lastPhaseId字段是否为空，如果" +
            "为空则跳转到夺宝页面，如果不为空则跳转到最新一期，如果状态为5，则弹出关注弹窗，使用hasAward和merchantInfoDTO进行展示，让用户对商家进行关注")
    private Integer joinResult;

    @ApiModelProperty("最后一期活动ID，如果不为空，可以跳转到当前活动对应的最后一期活动")
    private Long lastPhaseId;

    @ApiModelProperty("是否有商家福利，用于判断弹窗展示的文案，true表示有福利")
    private Boolean hasAward;

    @ApiModelProperty("赞助商家信息，可能为空，为空说明没有赞助商家")
    private LotteryMerchantInfoDTO merchantInfoDTO;

    @ApiModelProperty("参与成功后的奖券号码")
    private String code;

    @ApiModelProperty(value = "当前状态是否为处理成功，用于业务流转判断，不返回给前端", hidden = true)
    @JsonIgnore
    private Boolean success;

    public static LotteryJoinResultDTO buildDefault() {
        return LotteryJoinResultDTO.builder().success(true).build();
    }
}
