package com.bxm.localnews.merchant.dto.activity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author liujia
 * @date 2020-10-22 18:31
 **/
@ApiModel(description = "活动赞助商家信息")
@Data
public class LotteryMerchantInfoDTO {

    @ApiModelProperty("商家ID")
    private Long merchantId;

    @ApiModelProperty("商家名称")
    private String merchantName;

    @ApiModelProperty("商家地址")
    private String address;

    @ApiModelProperty("商家头图")
    private String logoImg;

    @ApiModelProperty("商家一句话简介")
    private String description;

    @ApiModelProperty("商家用户ID")
    private Long merchantUserId;

    @ApiModelProperty("商家用户昵称")
    private String merchantUserName;

    @ApiModelProperty("商家用户头像")
    private String merchantUserHeadImg;

    @ApiModelProperty("纬度")
    private BigDecimal lat;

    @ApiModelProperty("经度")
    private BigDecimal lng;

    @ApiModelProperty("当前用户是否已经关注商家，true表示已关注")
    private Boolean follow;
}
