package com.bxm.localnews.merchant.dto.activity;

import com.bxm.localnews.merchant.dto.AreaInfoDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author liujia
 * @date 2020-10-22 23:12
 **/
@ApiModel(description = "抽奖活动信息列表概述")
@Data
public class LotteryOverviewDTO {

    @ApiModelProperty("活动ID")
    private Long lotteryId;

    @ApiModelProperty("活动排序")
    private Integer order;

    @ApiModelProperty("活动标题")
    private String title;

    @ApiModelProperty("活动当前期数")
    private Integer currentPhaseNum;

    @ApiModelProperty("活动是否为真实用户中奖（true：真实用户)")
    private Boolean actualFlag;

    @ApiModelProperty("活动上下架状态,true:上架")
    private Boolean enable;

    @ApiModelProperty("是否全国投放，true：全国投放，false：地区投放（显示投放地区）")
    private Boolean globalFlag;

    @ApiModelProperty("投放地区")
    private List<AreaInfoDTO> areaList;

    @ApiModelProperty("所属商家id，可能为空说明没有商家赞助")
    private Long merchantId;

    @ApiModelProperty("店铺名称，可能为空说明没有商家赞助")
    private String merchantName;
}
