package com.bxm.localnews.merchant.dto.activity;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author liujia
 * @date 2020-10-22 18:28
 **/
@ApiModel(description = "活动参与者信息")
@Data
public class LotteryParticipatorDTO {

    @ApiModelProperty("参与人员ID")
    private Long userId;

    @ApiModelProperty("参与人昵称")
    private String nickName;

    @ApiModelProperty("参与人头像")
    private String headImg;

    @ApiModelProperty("参与时间 (已格式化)")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date joinTime;
}
