package com.bxm.localnews.merchant.dto.activity;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author liujia
 * @date 2020-10-22 18:35
 **/
@ApiModel(description = "活动期数基础信息")
@Data
public class LotteryPhaseBaseInfoDTO {
    @ApiModelProperty("活动ID")
    private Long lotteryId;

    @ApiModelProperty("当前活动期数ID")
    private Long phaseId;

    @ApiModelProperty("活动标题")
    private String title;

    @ApiModelProperty("活动期数")
    private Integer phaseNum;

    @ApiModelProperty("活动价值金额")
    private BigDecimal price;

    @ApiModelProperty("活动开启的目标人数")
    private Integer targetNum;

    @ApiModelProperty("活动当前参与人数")
    private Integer currentNum;

    @ApiModelProperty("奖品详情")
    private String detail;

    @ApiModelProperty("活动状态,0：未开始、1：进行中、2：已开奖、3：已终止")
    private Integer status;

    @ApiModelProperty("本期活动开始时间 (已格式化)")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date startTime;
}
