package com.bxm.localnews.merchant.dto.activity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.util.List;

/**
 * @author liujia
 * @date 2020-10-22 20:00
 **/
@ApiModel(description = "抽奖计算过程")
@Data
@Builder
public class LotteryPhaseCalculateDTO {

    @Tolerate
    public LotteryPhaseCalculateDTO() {
    }

    @ApiModelProperty("计算因子的汇总结果")
    private Long total;

    @ApiModelProperty("参与人员总数")
    private Integer totalNum;

    @ApiModelProperty("计算结果（中奖号码）")
    private String result;

    @ApiModelProperty("计算因子（参与夺宝时间列表）")
    private List<LotteryPhaseCalculatePartDTO> partList;
}
