package com.bxm.localnews.merchant.dto.activity;

import lombok.Data;

/**
 * 活动期数的核心相关数据，用于业务逻辑处理
 *
 * @author liujia
 * @date 2020-10-27 17:02
 **/
@Data
public class LotteryPhaseCoreInfoDTO {

    /**
     * 活动开奖的目标人数
     */
    private Integer targetNum;

    /**
     * 活动当前的参与人数
     */
    private Integer currentNum;

    /**
     * 活动的赞助商家（可能为空）
     */
    private Long merchantId;

    /**
     * 活动赞助商家的用户ID（可能为空）
     */
    private Long merchantUserId;

    /**
     * 关注商家是否有优惠，不为空表示存在
     */
    private Long couponId;

    /**
     * 参与活动需要消耗的金币（小红花）
     */
    private Integer expendGold;

    /**
     * 活动期数状态
     */
    private Integer status;

    /**
     * 活动是否存在最新一期
     */
    private Long lastPhaseId;

    /**
     * 用户允许参与活动的次数上限
     */
    private Integer maxTimes;

    /**
     * 活动期ID
     */
    private Long phaseId;

    /**
     * 活动ID
     */
    private Long lotteryId;

    /**
     * 活动标题
     */
    private String lotteryTitle;

    /**
     * 活动奖品ID
     */
    private Long awardId;

    /**
     * 是否真实用户中奖（1：真实用户中奖）
     */
    private Integer actualFlag;

    /**
     * 是否允许马甲号参与活动（1：允许）
     */
    private Integer virtualFlag;

    /**
     * 活动期号
     */
    private Integer phaseNum;
}
