package com.bxm.localnews.merchant.dto.activity;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * @author liujia
 * @date 2020-10-22 18:26
 **/
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "活动期数详情")
@Data
public class LotteryPhaseDetailDTO extends LotteryPhaseBaseInfoDTO {
    @ApiModelProperty("最后一期活动ID，如果不为空，可以跳转到当前活动对应的最后一期活动")
    private Long lastPhaseId;

    @ApiModelProperty("参与活动需要的小红花")
    private Integer expendGold;

    @ApiModelProperty("活动分享海报，如果未配置则为null")
    private String sharePoster;

    @ApiModelProperty("当前用户剩余可参与次数，如果状态为进行中并且值为0则表示无次数")
    private Integer joinTimes;

    @ApiModelProperty("活动轮播图")
    private List<String> imgList;

    @ApiModelProperty("活动赞助商家信息，可能为空")
    private LotteryMerchantInfoDTO merchantInfo;

    @ApiModelProperty("近期参与人员列表（滚动弹幕），可能为空")
    private List<LotteryParticipatorDTO> recentParticipatorList;

    @ApiModelProperty("当前用户持有的夺宝券号码，可能为空，如果不为空说明当前用户已经参与过本期活动")
    private List<String> myCodes;

    @ApiModelProperty("当前用户的邀请数据，可能为空")
    private LotteryInviteInfoDTO inviteInfo;

    @ApiModelProperty("开奖时间（中奖时间）(已格式化)【为已开奖这种情况提供】")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date phaseWinnerTime;

    @ApiModelProperty("活动中奖人员信息")
    private LotteryWinnerInfoDTO winnerInfo;
}
