package com.bxm.localnews.merchant.dto.activity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author liujia
 * @date 2020-10-22 17:54
 **/
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "活动期数的列表视图，包含当前用户的参与信息")
@Data
public class LotteryPhaseOverviewDTO extends LotteryPhaseBaseInfoDTO {

    @ApiModelProperty("活动头图")
    private String img;

    @ApiModelProperty("当前用户参与该活动次数")
    private Integer joinTimes;

    @ApiModelProperty("中奖人员信息，活动状态为已开奖时有值")
    private LotteryWinnerInfoDTO winner;
}
