package com.bxm.localnews.merchant.dto.activity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author wzy
 * @version 1.0
 * @date 2020/10/29 2:52 下午
 */
@Data
@ApiModel(description = "分享夺宝时海报生成需要的相关参数")
public class LotterySharePosterDTO {

    @ApiModelProperty("活动期ID")
    private Long phaseId;

    @ApiModelProperty("活动ID")
    private Long lotteryId;

    @ApiModelProperty("分享用户id")
    private Long userId;

    @ApiModelProperty("分享用户昵称")
    private String nickName;

    @ApiModelProperty("分享用户头像")
    private String headImg;

    @ApiModelProperty("奖品头图")
    private String img;

    @ApiModelProperty("奖品价格")
    private BigDecimal price;

    @ApiModelProperty("活动名称")
    private String title;

    @ApiModelProperty("商家地址")
    private String address;

    @ApiModelProperty("活动开奖的目标人数")
    private Integer targetNum;
}