package com.bxm.localnews.merchant.dto.activity;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author liujia
 * @date 2020-10-22 18:10
 **/
@ApiModel(description = "中奖人员信息")
@Data
public class LotteryWinnerInfoDTO {

    @ApiModelProperty("中奖纪录id")
    private Long winnerRecordId;

    @ApiModelProperty("中奖人员ID")
    private Long userId;

    @ApiModelProperty("中奖人昵称")
    private String nickName;

    @ApiModelProperty("中奖人头像")
    private String headImg;

    @ApiModelProperty("中奖号码")
    private String code;

    @ApiModelProperty("中奖人手机号码，仅在商家端会返回")
    private String phone;

    @ApiModelProperty("开奖时间（中奖时间）(已格式化)")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date winnerTime;
}
