package com.bxm.localnews.merchant.dto.activity;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * @author liujia
 * @date 2020-10-22 20:09
 **/
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel("中奖信息列表视图")
public class LotteryWinnerOverviewDTO extends LotteryPhaseBaseInfoDTO {

    @ApiModelProperty("中奖记录ID")
    private Long winnerRecordId;

    @ApiModelProperty("发奖的状态，0未发奖，1,2已发奖(2这里表示的是商家商品已核销，做一下兼容处理)")
    private Integer prizeStatus;

    @ApiModelProperty("中奖号码")
    private String code;

    @ApiModelProperty("开奖时间（中奖时间）(已格式化)")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date winnerTime;

    @ApiModelProperty("奖品头图")
    private String img;
}
