package com.bxm.localnews.merchant.dto.activity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author liujia
 * @date 2020-10-23 10:56
 **/
@ApiModel(description = "商家赞助商品的夺宝活动显示信息")
@Data
public class MerchantLotteryAwardDTO {

    @ApiModelProperty("商品头图")
    private String img;

    @ApiModelProperty("商品标题")
    private String title;

    @ApiModelProperty("奖品价格")
    private BigDecimal price;

    @ApiModelProperty("活动状态")
    private Integer status;

    @ApiModelProperty("奖品的使用状态（这个字段仅在已结束状态下使用）：1已核销，2待核销，3已发奖，4未发奖, 5已下架")
    private Integer useStatus;

    @ApiModelProperty("活动ID")
    private Long lotteryId;

    @ApiModelProperty("当前活动期数ID（查看、分享需要）")
    private Long currentPhaseId;

    @ApiModelProperty("当前活动期数")
    private Integer currentPhaseNum;

    @ApiModelProperty("曝光次数")
    private Integer showNum;

    @ApiModelProperty("参与人数")
    private Integer joinNum;

    @ApiModelProperty("活动分享海报，如果未配置则为null")
    private String sharePoster;

    @ApiModelProperty("吸粉人数")
    private Integer funsNum;

    @ApiModelProperty(value = "奖品的类型", hidden = true)
    private Integer type;

    @ApiModelProperty(value = "核销状态，是否发奖，0待发奖，1已发奖")
    private Integer checkStatus;

    @ApiModelProperty(value = "发奖状态,是否核销，0待核销，1已核销")
    private Integer awardStatus;

    @ApiModelProperty("中奖人员信息，仅在已结束状态中会返回")
    private LotteryWinnerInfoDTO winnerInfo;
}
