package com.bxm.localnews.merchant.entity.lottery;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author 活动奖品与核销信息
 */
@Data
public class ActivityPrizeEntity implements Serializable {
    /**
     * 主键
     */
    private Long id;

    /**
     * 所属业务ID
     */
    private Long bizId;

    /**
     * 奖品类型
     */
    private Integer type;

    /**
     * 奖品核销码
     */
    private String code;

    /**
     * 核销时间
     */
    private Date checkTime;

    /**
     * 快递公司
     */
    private String expressCompany;

    /**
     * 物流编号
     */
    private String expressNum;

    /**
     * 收货地址
     */
    private String deliveryAddress;

    /**
     * 奖品状态（待核销、已核销）
     */
    private Integer status;

    /**
     * 操作数据的运营人员ID
     */
    private Long operator;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 变更时间
     */
    private Date modifyTime;

    private static final long serialVersionUID = 1L;
}