package com.bxm.localnews.merchant.entity.lottery;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author 夺宝活动奖品信息
 */
@Data
public class LotteryAwardEntity implements Serializable {
    /**
     * 主键
     */
    private Long id;

    /**
     * 所属商家ID
     */
    private Long merchantId;

    /**
     * 商品ID
     */
    private Long goodsId;

    /**
     * 奖品类型（商品、虚拟物品、其他）
     */
    @NotNull
    private Integer type;

    /**
     * 奖品来源（1：商家，2：运营创建）
     */
    private Integer source;

    /**
     * 奖品标题
     */
    private String title;

    /**
     * 赞助商家ID，可以为空
     */
    private Long sponsor;

    /**
     * 奖品价值
     */
    private BigDecimal price;

    /**
     * 奖品库存数量
     */
    private Integer stock;

    /**
     * 已使用的库存数量
     */
    private Integer useStock;

    /**
     * 奖品有效期开始时间
     */
    private Date startTime;

    /**
     * 奖品失效时间
     */
    private Date expiredTime;

    /**
     * 商品显示的首图
     */
    private String firstImg;

    /**
     * 店铺简介
     */
    private String intro;

    /**
     * 被关注后的回复信息
     */
    private String replayContent;

    /**
     * 关注后的优惠券信息
     */
    private Long couponId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 变更时间
     */
    private Date modifyTime;

    /**
     * 创建人
     */
    private Long creator;

    private static final long serialVersionUID = 1L;
}