package com.bxm.localnews.merchant.entity.lottery;

import lombok.Data;

import javax.validation.constraints.Min;
import java.io.Serializable;
import java.util.Date;

/**
 * @author 夺宝活动信息
 */
@Data
public class LotteryEntity implements Serializable {
    /**
     * 主键
     */
    private Long id;

    /**
     * 活动顺序
     */
    private Integer order;

    /**
     * 活动标题
     */
    private String title;

    /**
     * 活动奖品ID
     */
    private Long awardId;

    /**
     * 活动开奖人次
     */
    @Min(value = 50, message = "活动开奖人数最少为50")
    private Integer targetNum;

    /**
     * 每日参与次数
     */
    @Min(value = 1)
    private Integer maxTimes;

    /**
     * 参与消耗的小红花
     */
    private Integer expendGold;

    /**
     * 是否全国项目，1：是，0：否
     */
    private Integer globalFlag;

    /**
     * 活动开启时间
     */
    private Date startTime;

    /**
     * 活动当前状态（1：上架，0：下架）
     */
    private Integer enable;

    /**
     * 活动创建时间
     */
    private Date createTime;

    /**
     * 活动创建人
     */
    private Long creator;

    /**
     * 活动变更时间
     */
    private Date modifyTime;

    /**
     * 分享的海报图片地址
     */
    private String sharePoster;

    /**
     * 是否真实用户中奖（1：是，0：否）
     */
    private Integer actualFlag;

    /**
     * 是否允许马甲号参与
     */
    private Integer virtualFlag;

    /**
     * 当前最新一期的ID
     */
    private Long currentPhaseId;

    /**
     * 当前期数
     */
    private Integer currentPhaseNum;

    /**
     * 删除标记，1：已删除，0：未删除
     */
    private Integer deleteFlag;

    /**
     * 删除时间
     */
    private Date deleteTime;

    /**
     * 删除操作的运营人员ID
     */
    private Long deleteUserId;

    /**
     * 活动状态
     */
    private Integer status;

    private static final long serialVersionUID = 1L;
}