package com.bxm.localnews.merchant.entity.lottery;

import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.io.Serializable;
import java.util.Date;

/**
 * @author 夺宝活动参与者
 */
@Data
@Builder
public class LotteryParticipatorEntity implements Serializable {

    @Tolerate
    public LotteryParticipatorEntity() {
    }

    /**
     * 主键
     */
    private Long id;

    /**
     * 参与活动期数ID
     */
    private Long phaseId;

    /**
     * 参见的活动ID
     */
    private Long lotteryId;

    /**
     * 参与人ID
     */
    private Long userId;

    /**
     * 参与人昵称
     */
    private String nickName;

    /**
     * 参与人头像
     */
    private String headImg;

    /**
     * 参与编码
     */
    private String code;

    /**
     * 参与时间
     */
    private Date createTime;

    /**
     * 参与人类型（1：有效用户，2：虚拟用户）
     */
    private Integer userType;

    /**
     * 参与用户的数据来源（区分站内、站外、邀请、虚拟用户）
     */
    private Integer source;

    private static final long serialVersionUID = 1L;
}