package com.bxm.localnews.merchant.param.activity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Size;

/**
 * @author liujia
 * @date 2020-10-22 18:22
 **/
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "活动赞助信息提交")
@Data
public class ActivityTrackParam extends LotteryBaseParam {

    @ApiModelProperty("联系人姓名")
    @Size(max = 30)
    private String name;

    @ApiModelProperty("联系人手机号码")
    @Size(max = 20)
    private String phone;

    @ApiModelProperty("赞助内容（奖品信息）")
    @Size(max = 300)
    private String content;
}
