package com.bxm.localnews.merchant.param.activity;

import com.bxm.newidea.component.vo.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author liujia
 * @date 2020-10-23 11:52
 **/
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "活动奖品管理分页查询参数")
@Data
public class LotteryAwardManagePageParam extends PageParam {

    private static final long serialVersionUID = 7619788157106516716L;
    @ApiModelProperty("奖品ID")
    private Long awardId;

    @ApiModelProperty("奖品标题")
    private String awardTitle;

    @ApiModelProperty("商家ID")
    private Long merchantId;

    @ApiModelProperty("商家店铺名称")
    private String merchantName;

    @ApiModelProperty("奖品类型，1：商品，2：其他（待定）")
    private Integer awardType;
}
