package com.bxm.localnews.merchant.param.activity;

import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.util.Date;

/**
 * 夺宝活动参与检查参数
 *
 * @author liujia
 * @date 2020-10-29 16:04
 **/
@Data
@Builder
public class LotteryCheckJoinTimesParam {

    @Tolerate
    public LotteryCheckJoinTimesParam() {
    }

    /**
     * 参与平台，用于区分站内还是站外
     */
    private Integer platform;

    /**
     * 用户ID，必传
     */
    private Long userId;

    /**
     * 活动期数ID，必传
     */
    private Long phaseId;

    /**
     * 夺宝活动的最多参与次数，如果为空，则额外去查询活动期数据
     */
    private Integer maxTimes;

    /**
     * 用户创建日期，如果为空，则需要去获取用户信息
     */
    private Date userCreateTime;
}
