package com.bxm.localnews.merchant.param.activity;

import com.bxm.newidea.component.vo.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author liujia
 * @date 2020-10-22 23:25
 **/
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "活动管理查询参数")
@Data
public class LotteryManageParam extends PageParam {
    private static final long serialVersionUID = 6206408947832513894L;
    @ApiModelProperty("活动ID")
    private Long lotteryId;

    @ApiModelProperty("活动名称，支持模糊查询")
    private String title;

    @ApiModelProperty("地区编码")
    private String areaCode;

    @ApiModelProperty("活动上下架状态,true:上架")
    private Boolean enable;

    @ApiModelProperty("商户名称")
    private String merchantName;
}
