package com.bxm.localnews.merchant.param.activity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

/**
 * 夺宝活动商家关注相关逻辑处理
 *
 * @author liujia
 * @date 2020-10-28 11:38
 **/
@Data
@Builder
@ApiModel(description = "因为夺宝活动关注商家")
public class LotteryMerchantFollowParam {
    @Tolerate
    public LotteryMerchantFollowParam() {
    }

    @ApiModelProperty("参与夺宝活动的用户ID")
    private Long userId;

    @ApiModelProperty("商家用户ID")
    private Long merchantUserId;

    @ApiModelProperty("参与的夺宝活动期数ID")
    private Long phaseId;
}
