package com.bxm.localnews.merchant.param.activity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;

/**
 * @author liujia
 * @date 2020-10-28 16:26
 **/
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "用户参与夺宝活动的参数")
@Data
public class LotteryPhaseJoinParam extends LotteryBaseParam {

    @ApiModelProperty(value = "活动期数ID", required = true)
    @NotNull
    private Long phaseId;

    @ApiModelProperty("分享夺宝活动的用户ID，站外参与特有参数")
    private Long shareUserId;

    @ApiModelProperty(value = "原始活动期数ID（最初从站内分享出去的活动，从其他访问链路进入详情参与时不传递此参数），站外参与特有参数")
    private Long sourcePhaseId;
}
