/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.merchant.controller;

import com.bxm.localnews.merchant.dto.*;
import com.bxm.localnews.merchant.param.MerchantCounterClueParam;
import com.bxm.localnews.merchant.param.MerchantCounterRankParam;
import com.bxm.localnews.merchant.service.count.MerchantActionRecordService;
import com.bxm.localnews.merchant.service.count.MerchantContentRecordService;
import com.bxm.localnews.merchant.service.count.MerchantMemberCounterService;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

import java.util.List;

/**
 * @author jieliGG
 * @date 2020/7/30 16:55
 * 商户数据统计接口
 **/
@Api(tags = " 11-04 商户数据统计接口API")
@RestController
@RequestMapping("{version}/merchant/counter")
public class MerchantCounterController {

    @Autowired
    private MerchantMemberCounterService merchantMemberCounterService;

    @Autowired
    private MerchantContentRecordService merchantContentRecordService;

    @Autowired
    private MerchantActionRecordService merchantActionRecordService;

    @ApiOperation(value = "11-04-01 [v1]获取我的贡献[员工和老板的共用接口]")
    @ApiVersion(1)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
            @ApiImplicitParam(name = "type", value = "0-我的贡献，1-员工贡献", required = true),
            @ApiImplicitParam(name = "merchantId", value = "商户id", required = true)
    })
    @GetMapping("getUserContribution")
    public ResponseJson<MerchantCounterTotalDTO> getUserContribution(Long userId, Integer type, Long merchantId) {
        return ResponseJson.ok(merchantMemberCounterService.getUserContribution(userId, type, merchantId));
    }

    @ApiOperation(value = "11-04-02 [v1] 排行榜", notes = "获取排行榜列表，分页")
    @ApiVersion(1)
    @GetMapping("getRankList")
    public ResponseJson<PageWarper<MerchantCounterRankDTO>> getRankList(MerchantCounterRankParam merchantCounterRankParam) {
        return ResponseJson.ok(merchantMemberCounterService.getRankList(merchantCounterRankParam));
    }

    @ApiOperation(value = "11-04-03 [v1] 获取老板的排名信息", notes = "获取老板在排行榜中的排名")
    @ApiVersion(1)
    @GetMapping("getBoosRank")
    public ResponseJson<MerchantCounterRankDTO> getBoosRank(MerchantCounterRankParam merchantCounterRankParam) {
        return ResponseJson.ok(merchantMemberCounterService.getBoosRank(merchantCounterRankParam));
    }

    @ApiOperation(value = "11-04-04 [v1] 获取所有线索列表", notes = "分页获取线索")
    @ApiVersion(1)
    @GetMapping("getCluePageList")
    public ResponseJson<PageWarper<MerchantCounterClueDTO>> getCluePageList(MerchantCounterClueParam merchantCounterClueParam) {
        return ResponseJson.ok(merchantActionRecordService.getCluePageList(merchantCounterClueParam));
    }


    @ApiOperation(value = "11-04-05 [v1] 获取我的营销文列表", notes = "分页获取营销文")
    @ApiVersion(1)
    @GetMapping("getShareContentList")
    public ResponseJson<PageWarper<MerchantCounterShareContentDTO>> getShareContentList(MerchantCounterClueParam merchantCounterClueParam) {
        return ResponseJson.ok(merchantContentRecordService.getShareContentList(merchantCounterClueParam));
    }

    @ApiOperation(value = "11-04-06 [v1] 营销动态-员工营销", notes = "分页员工营销数据接口")
    @ApiVersion(1)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
    })
    @GetMapping("getMarketingTrends")
    public ResponseJson<PageWarper<MerchantMarketingDTO>> getMarketingTrends(MerchantCounterClueParam merchantCounterClueParam) {
        return ResponseJson.ok(merchantContentRecordService.getMarketingTrends(merchantCounterClueParam));
    }

    @ApiOperation(value = "11-04-08 [v1]首页获取营销动态-员工营销", notes = "分页员工营销数据接口")
    @ApiVersion(1)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
    })
    @GetMapping("getMarketingTrendsTopTen")
    public ResponseJson<List<MerchantMarketingDTO>> getMarketingTrendsTopTen(MerchantCounterClueParam merchantCounterClueParam) {
        return ResponseJson.ok(merchantContentRecordService.getMarketingTrendsTopTen(merchantCounterClueParam));
    }


    @ApiOperation(value = "11-04-07 [v1] 首页排行榜", notes = "查询排行榜前三名信息")
    @ApiVersion(1)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
            @ApiImplicitParam(name = "merchantId", value = "商户id", required = true)
    })
    @GetMapping("getRankTop")
    public ResponseJson<List<MerchantCounterRankDTO>> getRankTop(@ApiIgnore MerchantCounterRankParam merchantCounterRankParam) {

        return ResponseJson.ok(merchantMemberCounterService.getRankTop(merchantCounterRankParam));
    }
}
