package com.bxm.localnews.merchant.controller;

import com.bxm.localnews.merchant.dto.RadioMessageDto;
import com.bxm.localnews.merchant.service.message.MerchantMessageService;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author: zhoujincheng
 * @create: 2020-07-31 14:43
 */
@Api(tags = "11-07 团队消息相关API")
@RestController
@AllArgsConstructor
@RequestMapping("{version}/merchant/message")
public class MerchantMessageController {

    private MerchantMessageService merchantMessageService;

    @ApiOperation(value = "11-07-1 【v1】获取广播消息", notes = "获取广播消息", httpMethod = "GET")
    @GetMapping("/getRadioMessage")
    @ApiVersion(1)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "merchantId", value = "商户id", required = true)
    })
    public ResponseJson<List<RadioMessageDto>> getRadioMessage(@RequestParam("merchantId") Long merchantId) {
        Message message = merchantMessageService.getRadioMessage(merchantId);
        if (message.isSuccess()) {
            return ResponseJson.ok(message.getParam("radioMessageDtoList"));
        }
        return ResponseJson.badReqeuset(message.getLastMessage()).build();
    }
}
