/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.merchant.controller;

import com.bxm.localnews.merchant.dto.MerchantOperatorOrderDTO;
import com.bxm.localnews.merchant.dto.MerchantOrderInfoDTO;
import com.bxm.localnews.merchant.dto.order.MerchantBuyPromoteDTO;
import com.bxm.localnews.merchant.param.MerchantH5OrderParam;
import com.bxm.localnews.merchant.param.MerchantOperatorOrderParam;
import com.bxm.localnews.merchant.param.order.MerchantBuyOrderParam;
import com.bxm.localnews.merchant.service.order.MerchantOrderInfoService;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.util.WebUtils;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;

/**
 * @author jieliGG
 * @date 2020/8/20 17:22
 * 商户订单管理
 **/
@Api(tags = "11-11 商户订单管理")
@RestController
@RequestMapping("{version}/merchant/order")
public class MerchantOrderController {

    @Autowired
    private MerchantOrderInfoService merchantOrderInfoService;

    @ApiOperation(value = "11-11-01 [v1]h5页面获取订单列表")
    @ApiVersion(1)
    @GetMapping("security/getList")
    public ResponseJson<PageWarper<MerchantOrderInfoDTO>> getList(MerchantH5OrderParam merchantH5OrderParam) {
        return ResponseJson.ok(merchantOrderInfoService.getPageList(merchantH5OrderParam));
    }


    @ApiOperation(value = "11-11-02 [v1]订单 同意/拒绝 退款")
    @ApiVersion(1)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "orderNo", value = "订单号", required = true, paramType = "body"),
            @ApiImplicitParam(name = "state", value = "类型 1-同意 0-拒绝", required = true, paramType = "body")
    })
    @PostMapping("security/operatorOrderRefund")
    public ResponseJson<Boolean> operatorOrderRefund(@ApiIgnore @RequestBody MerchantOperatorOrderParam merchantOperatorOrderParam) {
        return ResponseJson.ok(merchantOrderInfoService.operatorOrder(merchantOperatorOrderParam));
    }


    @ApiOperation(value = "11-11-03 [v1]订单核销")
    @ApiVersion(1)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "verificationCode", value = "核销码", required = true, paramType = "body"),
            @ApiImplicitParam(name = "merchantId", value = "商家id", required = true, paramType = "body")
    })
    @PostMapping("security/verificationOrder")
    public ResponseJson<MerchantOperatorOrderDTO> verificationOrder(@RequestBody @ApiIgnore MerchantOperatorOrderParam merchantOperatorOrderDTO) {
        return ResponseJson.ok(merchantOrderInfoService.verification(merchantOperatorOrderDTO));
    }

    @ApiOperation(value = "11-11-04 创建商家开通权益订单", notes = "触发支付，创建用户订单。前端通过返回的订单编号轮询订单当前状态进行后续处理")
    @PostMapping("/merchantBuyOrder")
    public ResponseJson<MerchantBuyPromoteDTO> merchantBuyOrder(@Valid @RequestBody MerchantBuyOrderParam param, HttpServletRequest request) {
        param.setRequestIp(WebUtils.getIpAddr(request));
        return ResponseJson.ok(merchantOrderInfoService.createMerchantOrder(param));
    }

}
