package com.bxm.localnews.merchant.controller.goods.activity;

import com.bxm.localnews.merchant.param.goods.activity.DiscountGroupGoodsQueryParam;
import com.bxm.localnews.merchant.service.goods.DiscountGroupGoodsService;
import com.bxm.localnews.merchant.vo.goods.activity.DiscountGroupGoodsVO;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * 优惠团购商品相关Controller
 *
 * @author wzy
 * @version 1.0
 * @date 2020/11/19 3:03 下午
 */
@Api(tags = " 11-18 优惠团购商品相关Controller")
@RestController
@RequestMapping("{version}/merchant/discountGroup/goods")
public class DiscountGroupGoodsController {

    @Resource
    private DiscountGroupGoodsService discountGroupGoodsService;

    @ApiOperation(value = "11-18-01 [v1]获取优惠团购商品列表", notes = "")
    @GetMapping("list")
    @ApiVersion(1)
    public ResponseJson<List<DiscountGroupGoodsVO>> list(DiscountGroupGoodsQueryParam param) {
        return ResponseJson.ok(discountGroupGoodsService.getList(param));
    }
}