package com.bxm.localnews.merchant.controller.goods.activity;

import com.bxm.localnews.merchant.param.goods.activity.MemberDayGoodsQueryParam;
import com.bxm.localnews.merchant.service.goods.MemberDayGoodsService;
import com.bxm.localnews.merchant.vo.goods.activity.MemberDayGoodsVO;
import com.bxm.localnews.merchant.vo.goods.activity.MemberDayIndustryVO;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * 五折会员日商品相关Controller
 *
 * @author wzy
 * @version 1.0
 * @date 2020/11/19 2:44 下午
 */
@Api(tags = " 11-17 5折会员日商品相关Controller")
@RestController
@RequestMapping("{version}/merchant/memberDay/goods")
public class MemberDayGoodsController {

    @Resource
    private MemberDayGoodsService memberDayGoodsService;

    @ApiOperation(value = "11-17-01 [v1]获取5折会员日商品列表", notes = "")
    @GetMapping("list")
    @ApiVersion(1)
    public ResponseJson<List<MemberDayGoodsVO>> list(@Validated MemberDayGoodsQueryParam param) {
        return ResponseJson.ok(memberDayGoodsService.getList(param));
    }

    @ApiOperation(value = "11-17-02 [v1]获取所有行业分类以及分类下5折会员日商品数量", notes = "")
    @GetMapping("categoryList")
    @ApiVersion(1)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "areaCode", value = "地区编码", required = true)
    })
    public ResponseJson<List<MemberDayIndustryVO>> getCategoryList(@RequestParam("areaCode") String areaCode) {
        return ResponseJson.ok(memberDayGoodsService.getCategoryList(areaCode));
    }
}