package com.bxm.localnews.merchant.controller;

import com.bxm.localnews.merchant.service.CategoryService;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author: zhoujincheng
 * @create: 2020-08-12 16:13
 */
@Api(tags = " 11-20 数据同步接口")
@RestController
@RequestMapping("{version}/merchant/public/data")
public class MerchantSynchronizeDataController {

    @Autowired
    private CategoryService categoryService;

    @ApiOperation(value = "11-05-10 【v1】同步数据接口,一次性调用", notes = "同步数据接口", httpMethod = "POST")
    @PostMapping("/goods/synchronizeData")
    @ApiVersion(1)
    public ResponseJson<Boolean> synchronizeGoodsData() {
        return ResponseJson.build(categoryService.synchronizeGoodsData());
    }

}
