package com.bxm.localnews.merchant.controller.account;

import com.bxm.localnews.merchant.dto.account.*;
import com.bxm.localnews.merchant.param.account.BossCashParam;
import com.bxm.localnews.merchant.param.account.MerchantBossTodayCountParam;
import com.bxm.localnews.merchant.param.account.MerchantBossTotalAccountParam;
import com.bxm.localnews.merchant.service.account.boss.BossAccountService;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.apache.ibatis.annotations.Param;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author pf.w
 * @date 2020/8/20 14:03
 **/
@Api(tags = " 11-10 商家账户相关")
@RestController
@AllArgsConstructor
@RequestMapping("{version}/merchant/security/account")
public class MerchantBossAccountController {

    private BossAccountService bossAccountService;

    @GetMapping("/accountToday")
    @ApiOperation(value = "11-10-01 [v1]今日业绩")
    @ApiVersion(1)
    public ResponseJson<BossTodayAccountDTO> accountToday(MerchantBossTodayCountParam param) {
        return ResponseJson.ok(bossAccountService.accountToday(param));
    }

    @GetMapping("/accountTotal")
    @ApiOperation(value = "11-10-02 [v1]商家总资产统计")
    @ApiVersion(1)
    public ResponseJson<BossTotalAccountDTO> accountTotal(MerchantBossTotalAccountParam param) {
        return ResponseJson.ok(bossAccountService.accountTotal(param));
    }

    @GetMapping("/accountCash")
    @ApiOperation(value = "11-10-03 [v1]商家资产流水")
    @ApiVersion(1)
    public ResponseJson<PageWarper<BossCashDTO>> accountCash(BossCashParam param) {
        return ResponseJson.ok(bossAccountService.accountCashFlows(param));
    }

    @GetMapping("/withdrawalInfo")
    @ApiOperation(value = "11-10-04 [v1]获取商家可提现金额和账号")
    @ApiVersion(1)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户Id", required = true),
            @ApiImplicitParam(name = "merchantId", value = "商家id", required = true)
    })
    public ResponseJson<BossWithdrawalInfoDTO> withdrawalInfo(@RequestParam Long userId, @Param("merchantId") Long merchantId) {
        return ResponseJson.ok(bossAccountService.withdrawInfoForAlipay(userId, merchantId));
    }

    @GetMapping("/getAccountDetailById")
    @ApiOperation(value = "11-10-05 [v1]获取账单详情")
    @ApiVersion(1)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "cashId", value = "明细id", required = true),
            @ApiImplicitParam(name = "cashType", value = "流水类型  0：入账  1：冻结", required = true)
    })
    public ResponseJson<MerchantOrderDetailDTO> getAccountDetailById(@RequestParam Long cashId, @RequestParam("cashType") Integer cashType) {
        return ResponseJson.ok(bossAccountService.getAccountDetailById(cashId, cashType));
    }
}
