/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.common.utils;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;

public class ValidateUtils {
    private ValidateUtils() {
    }

    private static Validator getInstance(boolean failFast) {
        return ((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).failFast(failFast).constraintValidatorPayload((Object)"zh_CN").buildValidatorFactory().getValidator();
    }

    public static <T> List<String> valid(T obj) {
        Set validate = ValidateUtils.getInstance(false).validate(obj, new Class[0]);
        return validate.stream().map(ConstraintViolation::getMessage).collect(Collectors.toList());
    }

    public static <T> String fastValid(T obj) {
        Set resultMsg = ValidateUtils.getInstance(true).validate(obj, new Class[0]);
        if (resultMsg.size() > 0) {
            return ((ConstraintViolation)resultMsg.iterator().next()).getMessage();
        }
        return null;
    }
}

