package com.bxm.localnews.merchant.coupon.facade.service;

import com.bxm.localnews.merchant.dto.coupon.MerchantCouponOverviewDTO;
import com.bxm.localnews.merchant.entity.coupon.MerchantCouponInfoEntity;
import com.bxm.localnews.merchant.param.coupon.MerchantCouponStatusPageParam;
import com.bxm.newidea.component.vo.PageWarper;

/**
 * @author liujia
 * @date 12/24/20 3:52 PM
 **/
public interface CouponFacadeService {

    /**
     * 分页查询商户的优惠券状态
     *
     * @param param 分页查询参数
     * @return 分页结果
     */
    PageWarper<MerchantCouponOverviewDTO> query(MerchantCouponStatusPageParam param);

    /**
     * 从数据库加载最新的优惠券信息
     *
     * @param couponId 优惠券ID
     * @return 优惠券详情
     */
    MerchantCouponInfoEntity getCouponDetail(Long couponId);
}
