package com.bxm.localnews.merchant.dto.coupon;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author liujia
 * @date 2020-09-21 16:15
 **/
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "优惠券概览信息")
@Data
public class MerchantCouponOverviewDTO extends BaseCouponInfoDTO {

    @ApiModelProperty("优惠券当前状态,1:可领取状态，2：未开始，3：已领完，97：已过期，98：已停用,99：已作废")
    private Integer status;

    @ApiModelProperty("剩余可领取数量")
    private Integer remainingQuantity;

    @ApiModelProperty("是否有金额使用门槛")
    private Boolean conditionAmount;
}
