package com.bxm.localnews.merchant.dto;

import lombok.Data;

import java.util.Date;

/**
 * t_user_invite_history
 * @author
 */
@Data
public class UserInviteHistoryBean {
    /**
     * 主键
     */
    private Long id;

    /**
     * 用户
     */
    private Long userId;

    /**
     * 邀请人ID
     */
    private Long inviteUserId;

    /**
     * 邀请人昵称
     */
    private String inviteUserNickname;

    /**
     * 邀请人头像
     */
    private String inviteHeadImg;

    /**
     * 邀请方式（帖子、新闻、VIP、商品等）
     */
    private String type;

    /**
     * 邀请方式对应的业务ID
     */
    private Long relationId;

    /**
     * 关联的业务标题（帖子标题、商品名称等）
     */
    private String relationTitle;

    /**
     * 是否激活VIP（0：否、1：是）
     */
    private Byte activeVip;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 变更时间
     */
    private Date modifyTime;
    /**
     * 师傅的师傅id
     */
    private Long inviteSuperUserId;
    /**
     * 师傅的师傅文章创建者id
     */
    private Long inviteCreatedUserId;
    /**
     * 自己的文章创建者id
     */
    private Long createdUserId;
    /**
     * 邀请数量
     */
    private Integer inviteNum;

}