package com.bxm.localnews.merchant.facade;

import com.bxm.localnews.merchant.dto.LocationDTO;
import com.bxm.localnews.merchant.facade.fallback.LocationFallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @Author: pf.w
 * @Date: 2020/7/13 20:07
 */
@FeignClient(value = "localnews", fallbackFactory = LocationFallbackFactory.class,primary = false)
public interface LocationFeignService {

    /**
     * 获取定位
     * @param code
     * @return
     */
    @GetMapping("/facade/location/info")
    ResponseEntity<LocationDTO> getLocationByGeocode(@RequestParam("code") String code);
}
